//  Simulation de filament d'une lampe
//	En fonction de l'intensité du courant, contrôler la couleur
//  de la lampe (fond simulé par une ellipse liée, #0)
//  Tension mesurée aux bornes d'une résistance (liée, #1).
//  Le courant est calculé à partir de la différence de tension
//  aux bornes de la résistance.


// PinModes: undef_mode=0, input, openCo, output, source

IoPin@ in_pin_1 = component.getPin("In1");
IoPin@ in_pin_2 = component.getPin("In2");
IoPin@ clk_pin = component.getPin("clk");

double max_current;
double resistance;

void setCurrent( double val) {
	max_current = val;
	if (max_current < 0) max_current=0;
}

double getCurrent( void ) {
	return max_current;
}

void setResistance( double val) {
	resistance = val;
	if (resistance < 0) resistance=0;
}

double getResistance( void ) {
	return resistance;
}

double getResVal(string s)
{
	double valeur = 0;
	valeur = parseFloat(s);
    return valeur;
}

void setup()
{
    print("filament init");
}

void reset()
{ 
    print("resetting filament"); 

	resistance = getResistance();
	print("Resistance = "+resistance);
	component.setPropStr(1, "Resistance", ""+resistance+" Ω");
	max_current = getCurrent();
	print("Max current = "+max_current);
    
    clk_pin.changeCallBack( element, true ); // Register for Input Port voltage changes
}

string colorStr(uint8 r, uint8 g, uint8 b)
{
    return "#" +
        formatInt(r, '0h', 2) +
        formatInt(g, '0h', 2) +
        formatInt(b, '0h', 2);
}

double time( void ) {
	uint64 ctime = component.circTime();
	return ctime/1000000000000.0;
}

void voltChanged()
{
    double input1 = in_pin_1.getVoltage();
    double input2 = in_pin_2.getVoltage();
	int c;
	string cstr;
	
	double a = (input1 - input2)/resistance/max_current;
	if (a < 0) {
		a = -a;
	}
	if (a < 1.0) {
		c = int(a*255.0);
		cstr = colorStr(c,c,0);
	} else {
		cstr = colorStr(255,0,0);
	}
	print(cstr);
	component.setPropStr(0, "Color", cstr);
}
